#version 330

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

in vec2 omega_phi[];

out vec3 color;
out vec2 uv;

uniform ivec2 screen_size;
uniform ivec2 sprite_size;
uniform float t;

struct vertex
{
    vec4 position;
    vec3 color;
    vec2 uv;
};

void push_vertex(vertex v)
{
    gl_Position = v.position;
    color = v.color;
    uv = v.uv;
    EmitVertex();
}

void main()
{
    vec4 in_position = gl_in[0].gl_Position;
    float arg = omega_phi[0].x*t + omega_phi[0].y;
    float sin_arg = sin(arg);
    float cos_arg = cos(arg);
    mat2 R = mat2(cos_arg, sin_arg, -sin_arg, cos_arg);

    vec2 d = vec2(sprite_size);
    vec2 pixel_offset = vec2(1.0);

    vec3 upper_right_color;
    for (int i = 0; i < 3; ++i)
    {
        upper_right_color[i] = float(in_position[i] > 0);
    }

    vertex vertices[4];
    vertices[0].position = in_position + in_position.z*vec4((R*(vec2(-d.x, -d.y) + pixel_offset)) / screen_size, vec2(0.0));
    vertices[0].color = vec3(0.0, 0.0, 1.0);
    vertices[0].uv = vec2(0.0, 1.0);

    vertices[1].position = in_position + in_position.z*vec4((R*(vec2( d.x, -d.y) + pixel_offset)) / screen_size, vec2(0.0));
    vertices[1].color = vec3(1.0, 0.0, 0.0);
    vertices[1].uv = vec2(1.0, 1.0);

    vertices[2].position = in_position + in_position.z*vec4((R*(vec2( d.x,  d.y) + pixel_offset)) / screen_size, vec2(0.0));
    vertices[2].color = upper_right_color;
    vertices[2].uv = vec2(1.0, 0.0);

    vertices[3].position = in_position + in_position.z*vec4((R*(vec2(-d.x,  d.y) + pixel_offset)) / screen_size, vec2(0.0));
    vertices[3].color = vec3(0.0, 1.0, 0.0);
    vertices[3].uv = vec2(0.0, 0.0);

    
    push_vertex(vertices[1]);
    push_vertex(vertices[2]);
    push_vertex(vertices[0]);
    push_vertex(vertices[3]);

    EndPrimitive();
}
